package com.indusind.api.test;


import com.fasterxml.jackson.databind.ObjectMapper;

import com.indusind.api.integrator.IBLPayloadGenerator_j;

import com.indusind.api.integrator.data.IBLAPIRequest;
import kong.unirest.HttpResponse;

import kong.unirest.Unirest;

public class TestPayloadGeerator1 {

public static void main(String[] args) {

try {

String payload = "{\"requestUUID\":\"12345657\",\"panNumber\":\"FGEPS7224F\",\"channelID\":\"COR\"}";
/*
* //String payload = "{\r\n" + "\r\n" + "    \"request\": {\r\n" + "\r\n" +
* "        \"header\": { \"requestUUID\": \"M2P7820801773596064794\", \"channelId\": \"M2P\" }, \"body\": {\r\n"
* + "\r\n" + "            \"pushOTPReq\": {\r\n" + "\r\n" +
* "                \"debitCard\": \"4035XXXXXXXX4832\", \"cvv\": \"null\", \"otp\": \"null\", \"expiryDate\": \"1026\", \"referenceNo\": \"5781892427174774584\", \"merchant\": \"null\", \"txnAmount\" : \"null\", \"currency\": \"null\", \"otpExpiryTime\": \"null\", \"actionType\": \"OTP\", \"cardType\": \"VISA\"\r\n"
* + "\r\n" + "            }\r\n" + "\r\n" + "        }\r\n" + "\r\n" +
* "    }\r\n" + "\r\n" + "}";
*/		
			


// BEFORE SENDING THE REQUEST INITIALIZE THE PAYLOAD GENERATOR OBJECT

IBLPayloadGenerator_j ipg = new IBLPayloadGenerator_j();

long over1 = System.currentTimeMillis();

// CALL THE getIBLPayload METHOD TO GET THE ENCRYPTED STRING -- ACCEPTED VALUES
// ARE UAT AND PROD

String iblpayload = ipg.getIBLPayload(payload, "PROD");

// FOLLOWING 2 LINES ARE TO CAPTURE ENCRYPT OVERHEAD -- IGNORE

System.out.println("encrypted payload is " + iblpayload);

System.out.println(System.currentTimeMillis() - over1);			
					


HttpResponse<String> response = Unirest.post("URL")

.header("IBL-client-id", "")

.header("IBL-client-secret", "")

.header("content-type", "application/json")

.header("cache-control", "no-cache")

.body(iblpayload) // PASS THE IBLPAYLOAD WHICH IS ENCRPTED AS THE BODY OF THE API

.asString();

String responseBody = response.getBody();

// PRINTING THE ENCRYPTED RESPONSE FOR TESTING PURPOSE

	System.out.println(responseBody);

	// CONVERT THE RESPONSE TO IBLAPIRequest CLASS using Jackson mapper

	ObjectMapper mapper = new ObjectMapper();

	IBLAPIRequest respPl = mapper.readValue(response.getBody(), IBLAPIRequest.class);


	// SAMPLE CODE TO CAPTURE THE DECRYPT OVERHEAD

	long start3 = System.currentTimeMillis();

	// PASS THE DATA ELEMENT VALUE TO THE DECRYPT METHOD

	String decryptedResponse = ipg.decrypt(respPl.getData());

	// PRINTING THE DECRYTPED RESPONSE FOR TESTING PURPOSE

		System.out.println("decrpted response     " + decryptedResponse);

		// SAMPLE CODE TO CAPTURE THE DECRYPT OVERHEAD -- CAN BE REMOVED

		long start4 = System.currentTimeMillis();

		System.out.println((double) (start4 - start3));

		} catch (Exception e) {

		// TODO Auto-generated catch block

		e.printStackTrace();

		}

		}

		}