package com.indusind.api.integrator;


import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Random;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import com.indusind.api.integrator.CONST.CERTCONST;

 class PublicKeyReader {

    
    private static PublicKey publicKey;
    
   
 

    private static PublicKey setPublicKey() throws FileNotFoundException, CertificateException {
    	
    	FileInputStream fin  = new FileInputStream (new File("/Users/chotu/vijaya/resea/indusind-publickey-uat.pem"));
    	CertificateFactory f = CertificateFactory.getInstance("X.509");
    	X509Certificate certificate = (X509Certificate)f.generateCertificate(fin);
    	PublicKey publicKey = certificate.getPublicKey();
    	
        return publicKey;
    }      
    
    protected static PublicKey getPublicKey(String env) throws Exception{
    	if (publicKey == null) {
    		synchronized("1") {
    			if (publicKey == null)
    			//publicKey = setPublicKey();			
    			initEncryption(CERTCONST.getCert(env));
    			System.out.println("got into init encryption");
    		}
    		
    	}
    	return publicKey;
    }
    
    public static void initEncryption(String keyString) throws CertificateException {
 	   
    	byte[] decodedCertificate = Base64.getDecoder().decode(keyString.getBytes()) ;
    		    CertificateFactory certificateFactory;
    		    X509Certificate  certificate = null;

    		    try {
    		         certificateFactory = CertificateFactory.getInstance("X.509");
    		         certificate = (X509Certificate) certificateFactory.generateCertificate(new  ByteArrayInputStream(decodedCertificate));
    		    } catch (CertificateException e) {
    		        e.printStackTrace();
    		    }

    		   
    	publicKey = certificate.getPublicKey();	   
 	 
    }
    
    
   
  
}
