package com.indusind.api.integrator;

import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;

import java.text.ParseException;
import java.util.Arrays;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

//import org.apache.commons.codec.binary.Base64;


import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter; 
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.fasterxml.jackson.core.JsonProcessingException;
//import com.nimbusds.jose.util.Base64URL;
import com.fasterxml.jackson.databind.ObjectMapper; 
import com.fasterxml.jackson.databind.ObjectWriter;

import com.indusind.api.integrator.data.IBLAPIRequest;
import com.indusind.api.integrator.data.IBLPayload; 




public final class IBLPayloadGenerator_j {
	
	SecretKey key = null;
	IBLAPIRequest iblRequest ;
	String env;
	String encodedKey = null;
	
	
	
	
	
	public String getIBLPayload(String payload, String env) throws Exception  {
		

		 KeyGenerator keyGen;
		 String json = null;
		 IBLAPIRequest iblRequest = new IBLAPIRequest();
		try {
		//Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
			keyGen = KeyGenerator.getInstance("AES");
		
		 keyGen.init(256);
	     key = keyGen.generateKey();
        // WRITE THE KEY TO BASE64 STRING
         byte[] rawData = key.getEncoded();
         String encodedKey=hex(rawData);

			System.out.println("Encoded key: " + encodedKey);


 	    //System.out.println("SYMMETRIC KEY:" +encodedKey);

	    //ENCRYPT BASE64 SYMMETRIC KEY STRING WITH RSA PUBLIC KEY

	    String encKey =   encryptSymmKey(encodedKey,env);
	    iblRequest.setKey(encKey);
        iblRequest.setBit(0);

	    //System.out.println(encodedKey);
		// ENCRYPT THE PAYLOAD WITH AES KEY GENERATED

		//byte[] key=secretKey.getEncoded();
		Payload pl = new Payload(payload);
		JWEHeader jweHeader = new JWEHeader.Builder(JWEAlgorithm.A256KW, EncryptionMethod.A256GCM).build();
		JWEObject jweObject = new JWEObject(jweHeader, pl);
		jweObject.encrypt(new AESEncrypter(key));
		String encryptedPayload = jweObject.serialize();

		iblRequest.setData(encryptedPayload);
		//System.out.println("\"data\"" +encryptedPayload);


		//iblRequest.setIP(jweObjectMilli.serialize());


		//IBLPayload iblPayload = new IBLPayload();
		//iblPayload.setRequest(iblRequest);
		//iblPayload.setKey(encodedKey);


		ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
		json = ow.writeValueAsString(iblRequest);
//
		 
		
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("IBLPL0001: Unable to generate payload "+e);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("IBLPL0006: Unable to generate payload "+e);
		}
		
		return json;
	
	}
	
	
	public  String decrypt(String encryptedResponse) throws Exception  {
		// DECRYPT THE PAYLOAD
		
		try {
			
			//byte[] decodedKey = parseHexStr2Byte(encodedKey);
		    //SecretKey originalKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
//			KeyGenerator keyGen;
//			keyGen = KeyGenerator.getInstance("AES");
//
//			keyGen.init(256);
//			key = keyGen.generateKey();
		    
				JWEObject decJweObject = JWEObject.parse(encryptedResponse);
				decJweObject.decrypt(new AESDecrypter(key));

				// Get the plain text
				Payload pl = decJweObject.getPayload();
			   // System.out.println("Decrypted Payload "+decJweObject.getPayload().toString());
			    return pl.toString();
		}catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("IBLPL0007: Unable to generate payload "+e);
		} catch (KeyLengthException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("IBLPL0008: Unable to generate payload "+e);
		} catch (JOSEException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new Exception("IBLPL0009: Unable to generate payload "+e);
		}
			
		
	}
	
	
/*	public static SecretKey generateSecretKey(String password, byte [] iv) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeySpec spec = new PBEKeySpec(password.toCharArray(), iv, 65536, 256); // AES-128
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] key = secretKeyFactory.generateSecret(spec).getEncoded();
        return new SecretKeySpec(key, "AES");
    }*/

	private   String encryptSymmKey(String symmkey, String env) throws Exception {
		
		
		RSAPublicKey publicKey= (RSAPublicKey)PublicKeyReader.getPublicKey(env);
        
		Payload pl = new Payload(symmkey);
		JWEHeader jweHeader = new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A256GCM).build();
		JWEObject jweObject = new JWEObject(jweHeader, pl);
		jweObject.encrypt(new RSAEncrypter(publicKey));
		
		String encryptedPayload = jweObject.serialize();
		//System.out.println("\"key\":" +encryptedPayload);
		
		return encryptedPayload;
	}
	
	
	private static String hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        
       // System.out.println("\"hex key \": "+result.toString());
        return result.toString();
    }
	
	
	 private static  byte[] parseHexStr2Byte(String hexStr) {
	        if (hexStr.length() < 1)
	            return null;
	        byte[] result = new byte[hexStr.length() / 2];
	        for (int i = 0; i < hexStr.length() / 2; i++) {
	            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1),
	                    16);
	            int low = Integer.parseInt(
	                    hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
	            result[i] = (byte) (high * 16 + low);
	        }
	        return result;
	    }
	
	 
	 
	 
}
