/*
 * Decompiled with CFR 0.152.
 */
package com.indusind.api.integrator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.indusind.api.integrator.PublicKeyReader;
import com.indusind.api.integrator.data.IBLAPIRequest;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public final class IBLPayloadGenerator_j {
    SecretKey key = null;
    IBLAPIRequest iblRequest;
    String env;
    String encodedKey = null;

    public String getIBLPayload(String payload, String env) throws Exception {
        String json = null;
        IBLAPIRequest iblRequest = new IBLAPIRequest();
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            this.key = keyGen.generateKey();
            byte[] rawData = this.key.getEncoded();
            String encodedKey = IBLPayloadGenerator_j.hex(rawData);
            System.out.println("Encoded key: " + encodedKey);
            String encKey = this.encryptSymmKey(encodedKey, env);
            iblRequest.setKey(encKey);
            iblRequest.setBit(0);
            Payload pl = new Payload(payload);
            JWEHeader jweHeader = new JWEHeader.Builder(JWEAlgorithm.A256KW, EncryptionMethod.A256GCM).build();
            JWEObject jweObject = new JWEObject(jweHeader, pl);
            jweObject.encrypt(new AESEncrypter(this.key));
            String encryptedPayload = jweObject.serialize();
            iblRequest.setData(encryptedPayload);
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            json = ow.writeValueAsString(iblRequest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception("IBLPL0001: Unable to generate payload " + e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("IBLPL0006: Unable to generate payload " + e);
        }
        return json;
    }

    public String decrypt(String encryptedResponse) throws Exception {
        try {
            JWEObject decJweObject = JWEObject.parse(encryptedResponse);
            decJweObject.decrypt(new AESDecrypter(this.key));
            Payload pl = decJweObject.getPayload();
            return pl.toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new Exception("IBLPL0007: Unable to generate payload " + e);
        }
        catch (KeyLengthException e) {
            e.printStackTrace();
            throw new Exception("IBLPL0008: Unable to generate payload " + e);
        }
        catch (JOSEException e) {
            e.printStackTrace();
            throw new Exception("IBLPL0009: Unable to generate payload " + e);
        }
    }

    private String encryptSymmKey(String symmkey, String env) throws Exception {
        RSAPublicKey publicKey = (RSAPublicKey)PublicKeyReader.getPublicKey(env);
        Payload pl = new Payload(symmkey);
        JWEHeader jweHeader = new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A256GCM).build();
        JWEObject jweObject = new JWEObject(jweHeader, pl);
        jweObject.encrypt(new RSAEncrypter(publicKey));
        String encryptedPayload = jweObject.serialize();
        return encryptedPayload;
    }

    private static String hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    private static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

